import argparse
import os.path

import shortcuts
from shortcuts.utils import download_shortcut, is_shortcut_url
import collections
import copy
import plistlib
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Type, Union
from utils import *
from tqdm import tqdm
import pandas as pd
import pickle

import os

def list_all_controls(use_url=True):
    set_controls = set()

    if use_url:
        df = pd.read_excel('./iCloud_Link_List (Books).xlsx')
        for url in tqdm(df['iCloud Links']):
            shortcut = download_shortcut(url)

            shortcut = plistlib.loads(shortcut)

            for action in shortcut['WFWorkflowActions']:
                if 'GroupingIdentifier' in action['WFWorkflowActionParameters'] or 'WFControlFlowMode' in  action['WFWorkflowActionParameters']:
                    set_controls.add(action['WFWorkflowActionIdentifier'])
            print(set_controls)
    else:
        folder_path = '/WorkFlow_LLM/News/Source File'

        items = os.listdir(folder_path)

        for file_name in items:
            if '.plist' in file_name or '.shortcut' in file_name:
                with open(folder_path + '/' + file_name, 'rb') as f:
                    shortcut = f.read()
                try:
                    shortcut = plistlib.loads(shortcut)

                    for action in shortcut['WFWorkflowActions']:
                        if 'GroupingIdentifier' in action['WFWorkflowActionParameters'] or 'WFControlFlowMode' in  action['WFWorkflowActionParameters']:
                            set_controls.add(action['WFWorkflowActionIdentifier'])
                    print(set_controls)
                except:
                    print(f'Error at {file_name}')



def _get_format(filepath: str) -> str:
    '''
    Args:
        filepath: path for a file which format needs to be determined

    Returns:
        file format (shortcut, toml or url)
    '''
    if type(filepath).__name__ == 'dict':
        return 'dict'

    if is_shortcut_url(filepath):
        return 'url'

    if filepath == '':
        return shortcuts.FMT_JSON

    _, ext = os.path.splitext(filepath)
    ext = ext.strip('.')
    if ext in (shortcuts.FMT_SHORTCUT, 'plist'):
        return shortcuts.FMT_SHORTCUT
    elif ext == 'toml':
        return shortcuts.FMT_TOML
    elif ext == 'json':
        return shortcuts.FMT_JSON
    raise RuntimeError(f'Unsupported file format: {filepath}: "{ext}"')



def replace_uuids(code, replace_dict):
    for uuid, variable in replace_dict.items():
        code = re.sub(r'\b{}\b'.format(re.escape(uuid)), variable, code)
    return code


def find_extra_uuids(code):
    uuid_pattern = re.compile(r'\b[A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12}\b')
    found_uuids = set(re.findall(uuid_pattern, code))

    return len(found_uuids) != 0

def convert_shortcut(input_filepath: str, title: str,) -> str:
    input_format = _get_format(input_filepath)

    if input_format == 'dict':
        sc_data = input_filepath
        shortcut_dict = {
            'WFWorkflowActions' : [sc_data]
        }
    else:
        if input_format == 'url':
            sc_data = download_shortcut(input_filepath)

        else:
            with open(input_filepath, 'rb') as f:
                sc_data = f.read()

        if isinstance(sc_data, str):
            sc_data = sc_data.encode('utf-8')

        shortcut_dict = plistlib.loads(sc_data)

    # Parse the shortcut script to AST
    parser = ShortcutParser(shortcut_dict['WFWorkflowActions'])
    try:
        parser.parse()
    except:
        print(f'Input Error at {input_filepath}')
        # [_['WFWorkflowActionParameters']['WFControlFlowMode'] for _ in shortcut_dict['WFWorkflowActions'] if 'condition' in str(_)]
        return None

    parser.add_necessary_UUID(parser.root)
    parser.handle_contrl_UUID(parser.root)

    parser.add_empty_child(parser.root)
    parser.mark_multi_repeat(parser.root)

    python_code = parser.to_python()

    return python_code

def main():
    parser = argparse.ArgumentParser(description='Shortcuts: Siri shortcuts creator')
    parser.add_argument(
        'file', nargs='?', help='Input file: *.(|shortcut|itunes url)',default='*'
    )

    args = parser.parse_args()


    if args.file != '*':
        title = args.file.split('/')[-1].split('.')[0]
        code = convert_shortcut(args.file, title)
        print(code)
    else:
        folder_path = '../model_related/data/Merged Shortcuts Dataset'
        infos = pd.read_excel(os.path.join(folder_path, 'iCloud_Link_List.xlsx'))

        # folder_path = './input_shortcuts'
        title2code = defaultdict(dict)

        for root, dirs, files in os.walk(folder_path):
            print(len(title2code))

            for file_name in files:
                if file_name.endswith('.plist') or file_name.endswith('.shortcut'):
                    title = file_name.split('.')[0]
                    print(os.path.join(root, file_name))

                    with open(os.path.join(root, file_name), 'rb') as f:
                        shortcut = f.read()
                    shortcut = plistlib.loads(shortcut)

                    code = convert_shortcut(os.path.join(root, file_name), title)

                    if code is not None:
                        title2code[title]['shortcut'] = shortcut
                        title2code[title]['code'] = code

                    # print(code)
                    # print('=' * 50)
        with open('case_study.pkl', 'wb') as file:
            pickle.dump(title2code, file)
        print('Final:', len(title2code))


if __name__ == '__main__':
    # list_all_controls(use_url=False)
    main()